//FloorMountingPostHoles.scad;

//Use FloorMountingPostHole six times 
//to generate six mounting post holes;

//FloorMountingPostHole generates one 
//mounting post hole centered at the origin, 
//resting on the XY plane and standing 
//vertically above that plane;
    
//On exit from this module, 
//each hole is a small cylinder;
//It doesn't become a hole until it is used 
//as the second argument of a 
//difference() command;

//For all holes, PostTapPhi = 2.5mm, 
//ready to be tapped for a 3mm screw;

//I need six mounting post holes,
//four for the PCB carrying 
//the XC4502 and the XC4512,
//and two for the PH9205 battery case;

include <BATT_Dimensions.scad>
use <BATT_FloorMountingPostHole.scad>;

module FloorMountingPostHoles()
{

echo("Begin FloorMountingPostHoles");
    

//DeltaZ is constant for all mounting posts;
DeltaZ = FloorZ -Fuzz;

//echo("Hole1 = ", Post1x, Post1y);
translate([Post1x, Post1y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);

//echo("Hole2 = ", Post2x, Post2y);
translate([Post2x, Post2y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);

//echo("Hole3 = ", Post3x, Post3y);
translate([Post3x, Post3y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);

//echo("Hole4 = ", Post4x, Post1y);
translate([Post4x, Post4y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);

//echo("Hole5 = ", Post5x, Post5y);
translate([Post5x, Post5y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);

//echo("Hole6 = ", Post6x, Post6y);
translate([Post6x, Post6y, DeltaZ])
    FloorMountingPostHole(PostTapPhi);


}
//
